global OriginalPath C:\Users\David\Documents\Abrams\AbramsDeterrenceAEJApp2011-0005Data
global OriginalPath C:\Users\David\Dropbox\Documents\Work\Library\Sentencing reform\AbramsDeterrenceAEJApp2011-0005Data
global ReplicationPath C:\Users\David\Dropbox\Documents\Work\Clients & prospects\GiveWell\Criminal justice\Replications


***
*** Abrams Table 3
***

* balpan is 0 for state level data, 1 for balanced panel of precincts using dates of implementation (as in Table 3), & 2 for balanced panel using dates of passage
global balpan 1
local datename = cond($balpan==1, "implementation", "passage")

use "$OriginalPath\AbramsDeterrence$balpan", clear // agency-level data--AbramsDeterrence1 based on date in effect, AbramsDeterrence2 based on date adopted
label var lnpcrrobgun    "Gun robbery rate"
label var lnpcrasltgun   "Gun assault rate"

xtset

outreg, clear(Table3)
qui forvalues lag=1/3 {
	cap drop Dyaddon
	gen byte Dyaddon = yaddon & !L`lag'.yaddon // repeals in CA and TN (see notes to Table 1) not included in treatment variable
	outreg, clear
	foreach post74 in 1 "year>1974" {
		foreach balanced in 1 "relyr>=-7 & relyr<=6" {
			foreach timetrend in "" c.year#i.FSTATE {
				reg lnpcrrobgun Dyaddon ymm dc* i.FSTATE i.year `timetrend' [pw = statepop] if `post74' & `balanced', cluster(FSTATE)
				outreg, merge keep(Dyaddon ymm) rtitle("`lag' `=plural(`lag',"year")' after add-on law" \ "  `datename' date" \ "`lag' `=plural(`lag',"year")' after MM law" \ "  `datename' date") ctitle("","") bdec(4) starloc(1) se `=cond(`lag'<3,`"addrows("") noauto"',"")' summstat("_" \ N \ r2)
			}
		}
	}
	outreg, append replay(Table3) store(Table3)
}
outreg, replay(Table3)


***
*** Build and impute data set
***

cd "$ReplicationPath"
set more off

/*
odbc load, clear dsn(Crime) exec("select * from [Abrams replication]")
saveold "$ReplicationPath\Abrams state-level", replace version(12)
*/


global AbramsLEAsOnly 0 // restrict to Abrams LEAs (approximately, as I did not match quite all)
global collapse 0 // collapse to state level or keep at LEA level?

*** Generate CDF of year-2000 population of LEAs and determine population minimum for 80% population covereage

* odbc load, clear dsn(UCR) exec("SELECT ORICode, UPOPTOT AS Pop FROM [LEA crosswalk] INNER JOIN (SELECT DISTINCT ORICode FROM Crimes) t ON [LEA crosswalk].ORI7=t.ORICode where UPOPTOT>0 and State<>'DC'")
* saveold "$ReplicationPath\Abrams year-2000 LEA populations", version(12) replace
use "$ReplicationPath\Abrams year-2000 LEA populations", clear

sort Pop
gen Cum = Pop in 1
replace Cum = Cum[_n-1] + Pop if _n>1
gen CDF = Cum / Cum[_N]
sum Pop if CDF > .2 // sample representing 80% of population
global MinPop = r(min)
sum Pop
global TotPop = r(sum)

* Base data set: to control file size, retains only LEAs with population>=10000
/*#delimit ;
odbc load, clear dsn(Crime) exec(`"
	SELECT       UCR.dbo.Crimes.PostalCode, [Sin taxes].dbo.States.FIPS AS FIPSState, UCR.dbo.Crimes.ORICode, UCR.dbo.Crimes.Month, UCR.dbo.Crimes.Year, UCR.dbo.Crimes.ActNumGunRobber AS rrobgun, 
													 UCR.dbo.Crimes.ActNumRobbryTot AS rrobtot, UCR.dbo.Crimes.ActNumGunAssaul AS rasltgun, UCR.dbo.Crimes.ActNumAssltTota AS raslttot, UCR.dbo.Crimes.Population AS Pop, 
													 cast(CASE WHEN UCR.dbo.Crimes.ActNumAllFields > 0 THEN 1 ELSE 0 END as bit) AS HasTotal, 
													 [Abrams chronology].[Add-on passage] as AddOnPassDate, [Abrams city code crosswalk].city AS AbramsCity, UCR.dbo.[LEA crosswalk].UPOPTOT as Pop2000,
													 case when (UCR.dbo.[Targonski missingness].CI IS NULL OR (UCR.dbo.[Targonski missingness].CI NOT IN (-99, -98, -93, -94, -90, -85, -80)
																								`=cond($Quarterly     , "AND (UCR.dbo.[Targonski missingness].CI>-100 OR (-UCR.dbo.[Targonski missingness].CI-101)/3=(UCR.dbo.Crimes.Month-1)/3)","")')) then 0 else 1 end as TargonskiMissing
	FROM            UCR.dbo.Crimes INNER JOIN
													 UCR.dbo.[LEA crosswalk] ON UCR.dbo.Crimes.ORICode = UCR.dbo.[LEA crosswalk].ORI7 INNER JOIN
													 [Sin taxes].dbo.States ON UCR.dbo.Crimes.PostalCode = [Sin taxes].dbo.States.[Postal code] INNER JOIN
													 [Abrams chronology] ON [Sin taxes].dbo.States.[Postal code] = [Abrams chronology].[Postal code] AND UCR.dbo.Crimes.PostalCode = [Abrams chronology].[Postal code] LEFT OUTER JOIN
													 [Abrams city code crosswalk] ON UCR.dbo.Crimes.ORICode = [Abrams city code crosswalk].ORICode LEFT OUTER JOIN
													 UCR.dbo.[Targonski missingness] ON UCR.dbo.Crimes.ORICode = UCR.dbo.[Targonski missingness].ORICode AND UCR.dbo.Crimes.Month = UCR.dbo.[Targonski missingness].Month AND 
													 UCR.dbo.Crimes.Year = UCR.dbo.[Targonski missingness].Year LEFT OUTER JOIN
													 [Abrams city code crosswalk] AS [Abrams city code crosswalk_1] ON UCR.dbo.Crimes.ORICode = [Abrams city code crosswalk_1].ORICode
	WHERE        UCR.dbo.Crimes.Year>=1965 AND ([Abrams city code crosswalk].city IS NOT NULL OR UCR.dbo.[LEA crosswalk].UPOPTOT>=10000)
"');
#delimit cr
compress
saveold "$ReplicationPath\Abrams", replace version(12)*/

use "$ReplicationPath\Abrams" if `=cond($AbramsLEAsOnly, "AbramsCity<.", "Pop2000>=$MinPop")', clear
ren Year ty
replace AddOnPassDate = mofd(dofc(AddOnPassDate))
gen tm = ym(ty, Month)
format %tm AddOnPassDate tm
egen id = group(ORICode)
recode Pop 0 = .
gen double lnPop = ln(Pop)

* Estimate population-weighted share of Abrams data set that was imputed (for gun robbery)
preserve
use "$OriginalPath\AbramsDeterrence2", clear
keep year rrobgun statepop city
ren (year rrobgun statepop city) (ty _rrobgun _Pop AbramsCity)
tempfile file
save "`file'"
restore
preserve
collapse (sum) rrobgun (first) FIPSState AddOnPassDate Pop, by(AbramsCity ty) fast
merge 1:1 AbramsCity ty using "`file'", keep(match using)
gen byte imputed = rrobgun!=_rrobgun | Pop!=_Pop
di "Population-weighted share of annual totals that differ in Abrams and raw FBI data:"
sum imputed [aw=Pop]
sum imputed [aw=Pop] if ty>=1970 & ty<=1999
restore

* Mark an assault or robbery entry as missing if
*    it is negative;
*    if the count for the gun subcategory exceeds that for the larger category, or if it equals the count for the larger category and both exceed 100;
*    if total crime in a given year does not follow a perfect monthly, quarterly, semiannual, or annual pattern of non-zeroness
*    or if the total crime count is identified as missing by Targonski (2004, covering 1977–2000; codes -99, -98, -93, -94, -90, -85, -80 in a “CI” field).
egen HasTotalMonthly    = min(HasTotal == !mod(Month,1 )), by(id ty) // crime data for every month this year?
egen HasTotalQuarterly  = min(HasTotal == !mod(Month,3 )), by(id ty)
egen HasTotalSemiannual = min(HasTotal == !mod(Month,6 )), by(id ty)
egen HasTotalAnnual     = min(HasTotal == !mod(Month,12)), by(id ty)
foreach var in rob aslt {
	egen Sumr`var'tot = sum(r`var'tot), by(id ty)
	egen Sumr`var'gun = sum(r`var'gun), by(id ty)
	replace r`var'tot=. if TargonskiMissing | r`var'tot < 0
	replace r`var'gun=. if TargonskiMissing | r`var'gun < 0 | r`var'gun > r`var'tot | (r`var'gun==0 & r`var'tot>=50) | ((Sumr`var'gun==0 | Sumr`var'gun==Sumr`var'tot) & Sumr`var'tot>=100)
}

foreach Freq in m y /*q*/ {
	preserve
	foreach var in rob aslt {
		if "`Freq'"=="y" {
			replace r`var'tot = . if !(HasTotalSemiannual | HasTotalAnnual | HasTotalQuarterly | HasTotalMonthly)
			replace r`var'gun = . if !(HasTotalSemiannual | HasTotalAnnual | HasTotalQuarterly | HasTotalMonthly)
		}
		else if "`Freq'"=="q" {
			replace r`var'tot = . if !(HasTotalQuarterly | HasTotalMonthly)
			replace r`var'gun = . if !(HasTotalQuarterly | HasTotalMonthly)
		}
		else {
			replace r`var'tot = . if !HasTotalMonthly
			replace r`var'gun = . if !HasTotalMonthly
		}
	}

	keep FIPSState PostalCode ORICode AbramsCity Month ty tm rrobgun rrobtot rasltgun raslttot id Pop lnPop AddOnPassDate Pop2000

	xtset id tm
	tsfill, full // fill out to balanced panel
	foreach var in FIPSState AddOnPassDate { // fill in certain state-level vars in new observations
		replace `var' = L.`var' if `var'==.
		by id: replace `var' = `var'[_N]
	}
	replace ty = yofd(dofm(tm))
	gen tq = floor(tm/3)
	replace Month = mod(tm,12)+1
	gen byte T = tm >= AddOnPassDate // month of passage is viewed as partially treated
	drop AddOnPassDate

	bysort id T: egen t = sum(rrobgun) // if a time series has no non-zero gun robbery entries, we can't impute it with a model with LEA fixed effects
	di "Time series with no non-zero gun robbery entries; all dropped."
	tab id T if t==0
	by id: egen t2 = max(Pop2000 * !t)
	sum t2 if tm==tm(2000m1) & t2>0
	di `r(N)' " entirely dropped LEAs, with year-2000 population " %12.0f r(sum) ", which is " r(sum)/$TotPop " of total."
	drop if t==0
	drop t t2 Pop2000

* Force monotonicity in missingness to reduce computational burden of multivariate imputation;Pop < rrobtot < raslttot < rrobgun < rasltgun. Before these changes, missingness is neraly monotone
	replace rrobgun  = . if lnPop    == . & rrobgun  != .

	if "`Freq'"=="m" { // cited in journal supplementary materials
		gen byte miss = rrobgun==. | Pop==0 | Pop==.
		noi di "Missing fraction of gun robberies. Abrams LEAs only = $AbramsLEAsOnly"
		sum miss [aw=Pop] if ty>=1970 & ty<=1999
	}

	** Before imputation, compare missing-coded data to Abrams
/*	if $AbramsLEAsOnly & "`Freq'"=="y" {
		preserve
		use "$OriginalPath\AbramsDeterrence2", clear
		keep year FSTATE rrobtot rrobgun raslttot rasltgun statepop lnpc* dc* relyr city
		ren (year FSTATE rrobtot rrobgun raslttot rasltgun statepop lnpc* dc* relyr city) (ty FIPSState _rrobtot _rrobgun _raslttot _rasltgun _Pop _lnpc* _dc* _relyr AbramsCity)
		tempfile file
		save "`file'"
		restore
		preserve
		collapse (sum) rrobgun rrobtot rasltgun raslttot (count) Nrrobgun=rrobgun (first) FIPSState AddOnPassDate Pop, by(AbramsCity ty PostalCode ORICode) fast
		replace rrobgun=. if Nrrobgun<12
		merge 1:1 AbramsCity ty using "`file'"
		gen lnpcrrobgun = ln(rrobgun/Pop)
		gen str9 label = ORICode + substr(string(ty),3,2)
		scatter *lnpcrrobgun if lnpcrrobgun<., mlab(label)
		restore
	}*/

	mi set flong
	mi xtset id tm
	mi register imputed lnPop /*rrobtot raslttot*/ rrobgun /*rasltgun*/

	* number of entries to be imputed
	foreach var in lnPop rrobgun {
		count if `var'==.
	}

	recode FIPSState (10 = `=cond($AbramsLEAsOnly, 24, 10)'), gen(_FIPSState) // for Abrams-LEA-only imputations, group tiny DE with MD to avoid degeneracy from perfect model fit for lnPop)

	set seed 987654321
	mi impute monotone (reg lnPop i.ty i.id) /// 
	                   (nbreg rrobgun i.ty i.Month i.id                                                                                                                                                                               , off(lnPop) iter(20)) ///
		, by(_FIPSState T) custom add(5) force noi dots noupdate nomonotonechk

	replace Pop = exp(lnPop)

	if $collapse | "`Freq'"!="m" {
		mi unregister rrobgun rrobtot rasltgun raslttot lnPop
		collapse (sum) Pop rrobgun rrobtot rasltgun raslttot (max) _mi_miss, fast by(_mi_m `=cond($collapse,"","id")' FIPSState ty `=cond("`Freq'"=="y","",cond("`Freq'"=="q","tq","Month tm"))')
		     if "`Freq'"=="y" replace Pop = Pop / 12
		else if "`Freq'"=="q" replace Pop = Pop / 3
		by _mi_m: gen _mi_id = _n
		mi xtset `=cond($collapse,"FIPSState","id")' t`Freq'
	}

	ren ty Year
	mi merge m:1 FIPSState Year using "$ReplicationPath\Abrams state-level", noupdate keep(match master)
	ren Year ty
	sort _mi_m `_dta[iis]' `_dta[tis]'
	gen relAddOn = t`Freq' - `Freq'ofd(dofc(AddOnPassDate)) if AddOnPassDate>tc(1jan1900 00:00:00)
	gen relMM    = t`Freq' - `Freq'ofd(dofc(       MMDate)) if        MMDate>tc(1jan1900 00:00:00)
	foreach var of varlist rrob* raslt* {
		gen double lnpc`var' = ln(`var'/Pop)
	}

	* Mark, in all imputations, observations of gun crimes that are zero for at least one. -mi estimate: regress lnpcXXX - wants exact same sample for each imputation.
	foreach crime in aslt rob {
		egen r`crime'gunImputedZeroes = max(r`crime'gun==0 & _mi_m), by(FIPSState `_dta[tis]')
	}

	save `"$ReplicationPath\Abrams MI`=cond($collapse," collapsed","")'`=cond($AbramsLEAsOnly," Abrams LEAs","")' `Freq'"', replace

	restore
}


***
*** Compare averaged MI data sets to Abrams state panel
***

global AbramsLEAsOnly 1

use "$OriginalPath\AbramsDeterrence2", clear
collapse (sum) rrobtot rrobgun raslttot rasltgun statepop (first) dc* relyr, by(FSTATE year) fast
ren (year FSTATE rrobtot rrobgun raslttot rasltgun statepop dc* relyr) (ty FIPSState _rrobtot _rrobgun _raslttot _rasltgun _Pop _dc* _relyr)
tempfile file
save "`file'"
use `"$ReplicationPath\Abrams MI`=cond($AbramsLEAsOnly," Abrams LEAs","")' y"' if ty>=1970 & ty<=1999 & AddOnPassDate>tc(01jan1900 00:00:00) & AddOnPassDate<., clear
mi unset
order PostalCode
collapse Pop rrobgun rrobtot rasltgun raslttot if mi_m, by(mi_m FIPSState PostalCode ty) fast
foreach var in rrobtot rrobgun raslttot rasltgun {
	gen double lnpc`var' = ln(`var'/Pop)
}
collapse Pop lnpc*, by(FIPSState PostalCode ty) fast
joinby FIPSState ty using "`file'", unmatched(master)

label var lnpcrrobtot "Robberies"
label var lnpcrrobgun "Robberies with gun"
label var lnpcraslttot "Assaults"
label var lnpcrasltgun "Assaults with gun"
gen str4 label = PostalCode + substr(string(ty),3,2)
local i 0
set scheme s1color
foreach var in rrobtot rrobgun raslttot rasltgun {
	local ++i
	gen _lnpc`var' = ln(_`var'/_Pop)
	corr lnpc`var' _lnpc`var' [aw = Pop]
	scatter lnpc`var' _lnpc`var', ///
		name(`var', replace) mlab(label) msym(none) mlabpos(0) mlabsize(small) ///
		ytitle(`"`=cond(mod(`i',2),"New data","")'"') xtitle(`"`=cond(`i'>2,"Abrams data","")'"') title("`:var label lnpc`var'' ", size(medlarge)) ///
		note(`"Correlation = `=string(r(rho),"%4.2f")'"', pos(5) ring(0)) ylabel(, tlen(*.5) labgap(0) angle(horizontal) labsize(small)) xlabel(, labsize(small))
}
graph combine rrobtot rrobgun raslttot rasltgun, imargin(zero) graphregion(margin(zero)) name(all, replace)
graph export "$ReplicationPath\Abrams vs. replication scatters.png", replace width(1000)

foreach var of varlist dc* {
	scatter `var' _`var', mlab(label) name(`var', replace)
}


***
*** MI panel estimation
***

global AbramsLEAsOnly 0
global Freq y
global EventType Pass // Pass or Eff for passage or effective date--but note that the imputations respect Pass discontinuity
local datename = cond("$EventType"=="Eff", "implementation", "passage")

use `"$ReplicationPath\Abrams MI`=cond($AbramsLEAsOnly," Abrams LEAs","")' $Freq"', clear
gen double lnPop = ln(Pop)

local datename = cond("$EventType"=="Eff", "implementation", "passage")
replace AddOn${EventType}Date = yofd(dofc(AddOn${EventType}Date))
replace MMDate                = yofd(dofc(MMDate))
gen byte yAddOn = ty >= AddOn${EventType}Date
gen byte yMM    = ty >= MMDate
replace ty = ty - 1960

label var lnpcrrobgun  "Gun robbery rate"
label var lnpcrasltgun "Gun assault rate"

outreg, clear(MITable3)
forvalues lag=1/3 {
	outreg, clear
	cap drop DyAddOn
	gen byte DyAddOn = yAddOn & !yAddOn[_n-`lag'] & FIPSState==FIPSState[_n-`lag'] // equivalent to "yAddOn & !L`lag'.yAddOn" while avoiding lag operators, which don't work in mi data
	foreach post74 in 1 "ty>1974-1960" {
		foreach balanced in 1 "relAddOn>=-7 & relAddOn<=6" {
			foreach timetrend in "" c.ty#i.FIPSState {
				if $collapse | 1 mi estimate, noupdate post: regress lnpcrrobgun DyAddOn yMM dc* i.ty i.FIPSState `timetrend' [pw=Pop] if `post74' & `balanced', cluster(FIPSState)
				  else       mi estimate, noupdate post: poisson     rrobgun DyAddOn yMM dc* i.ty i.FIPSState `timetrend'          if `post74' & `balanced', cluster(FIPSState) off(lnPop)
				outreg, merge keep(DyAddOn yMM) coljust(l{c}c) rtitle("`lag' `=plural(`lag',"year")' after add-on law" \ "   `datename' date" \ "`lag' `=plural(`lag',"year")' after MM law" \ "  `datename' date") ctitle("","") bdec(4) starloc(1) starlevels(10 5 1) se `=cond(`lag'<3,`"addrows("") noauto"',"")' summstat("_" \ N_mi) nodisplay
			}
		}
	}
	outreg, append replay(MITable3) store(MITable3) coljust(l{c}c)
}
outreg using "$ReplicationPath\Abrams replication", replace replay(MITable3)


***
*** non-MI and MI panel estimation summary, focussing on Abrams Table 3, cols 2 & 6
***

outreg, clear(MITable3Summ)
forvalues lag=1/3 {
	outreg, clear

	forvalues balpan=1/2 {
		use "$OriginalPath\AbramsDeterrence`balpan'", clear // Abrams-posted LEA-level panel data, calibrated to date of implementation or passage
		xtset
		
		gen byte Dyaddon = yaddon & !L`lag'.yaddon // repeals in CA and TN (see notes to Table 1) not included in treatment variable
		foreach post74 in 1 "year>1974" {
			reg lnpcrrobgun Dyaddon ymm dc* i.year c.year##i.FSTATE [pw = statepop] if `post74', cluster(FSTATE)
			outreg, merge keep(Dyaddon) rtitle("`lag' `=plural(`lag',"year")' after add-on law" \ "  passage") ctitle("","") bdec(4) starloc(1) starlevels(10 5 1) se `=cond(`lag'<3,`"addrows("") noauto"',"")' summstat("_" \ N) summtitle("_"\"N")
		}
	}

	foreach AbramsLEAs in " Abrams LEAs" "" {
		use "$ReplicationPath\Abrams MI`AbramsLEAs' y", clear
		gen double lnPop = ln(Pop)
		replace AddOnPassDate = yofd(dofc(AddOnPassDate))
		replace MMDate        = yofd(dofc(MMDate))
		gen byte yAddOn = ty >= AddOnPassDate
		gen byte yMM    = ty >= MMDate
		replace ty = ty - 1960
		gen byte DyAddOn = yAddOn & !yAddOn[_n-`lag'] & id==id[_n-`lag'] // equivalent to "yAddOn & !L`lag'.yAddOn" while avoiding lag operators, which don't work on mi data
		foreach post74 in 1 "ty>1974-1960" {
			mi estimate, noupdate post esampvaryok: regress lnpcrrobgun DyAddOn yMM dc* i.ty c.ty##i.FIPSState [pw=Pop] if `post74', cluster(FIPSState)
*			mi estimate, noupdate post esampvaryok: nbreg       rrobgun DyAddOn yMM dc* i.ty c.ty##i.FIPSState          if `post74', cluster(FIPSState) off(lnPop)
			outreg, merge keep(DyAddOn) coljust(l{c}c) rtitle("`lag' `=plural(`lag',"year")' after add-on law" \ "  passage") ctitle("","") bdec(4) starloc(1) starlevels(10 5 1) se `=cond(`lag'<3,`"addrows("") noauto"',"")' summstat("_" \ N_mi) summtitle("_"\"N") nodisplay
		}
	}
	outreg, append replay(MITable3Summ) store(MITable3Summ)
}
outreg using "$ReplicationPath\Abrams panel replication summary", replay(MITable3Summ) replace


***
*** MI event study
***

set scheme s1color
global range 6 // time range of graphs

use "$OriginalPath\AbramsDeterrence2", clear
replace relyr = -7 if relyr < -7
replace relyr =  6 if relyr >  6 & relyr < .
egen _rel = group(relyr), label // "i." operator doesn't like negative values in relyr
levelsof _rel if relyr==0
global rel0 `r(levels)'
sum _rel, meanonly
global relmax `r(max)'

forvalues r=1/3 { // replace dummies for immediate pre- and post- r-year ranges with linear splines and test for difference in slopes
	cap drop PreSpline PostSpline
	gen byte PreSpline  = (relyr<0) * (relyr>=-`r') * relyr
	gen byte PostSpline = (relyr>0) * (relyr<= `r') * relyr
	regress lnpcrrobgun *Spline i(1/`=$rel0-`r'-1' `=$rel0+`r'+1'/$relmax)b$rel0._rel i.FSTATE i.year dc* [pw=statepop], cluster(FSTATE)
	test PreSpline = PostSpline
	local p`r' = substr(string(`r(p)', "%4.2f"), 2, .)
	scalar PreSpline`r'  = _b[PreSpline]
	scalar PostSpline`r' = _b[PostSpline]
}

reg lnpcrrobgun i.b$rel0._rel i.FSTATE i.year dc* [pw=statepop], cluster(FSTATE)

fvexpand i(`=$rel0-$range'/`=$rel0+$range')._rel
coefplot , keep(`=subinstr("`r(varlist)'","b.",".",.)') base cismooth(n(10) lwidth(2 11) intensity(10 100) color(blue)) vertical ///
	xlabel(1 "-6" 2 "-5" 3 "-4" 4 "-3" 5 "-2" 6 "-1" 7 "0" 8 "1" 9 "2" 10 "3" 11 "4" 12 "5" 13 "6", labsize(small)) ///
	ylabel(0 "0%" `=ln(1.5)' "+50%" `=ln(.75)' "-25%", tlen(*.5) labgap(0) angle(horizontal) labsize(small)) title("Abrams data", bmargin(zero)) subtitle(" ") ///
	xline(`=$range+1') ///
	mcolor(none) ///
	graphregion(margin(zero)) legend(off) msize(small) ///
	text(`=ln(.56)' .5 "{it:p} = `p1', `p2', `p3'", place(e) margin(zero)) ///
	yscale(range(`=ln(.55)' `=ln(1.7)')) ///
	generate replace

`r(graph)' || scatteri `=PreSpline3*-3' `=($range-3)+1' 0 `=($range-0)+1' `=PostSpline3*3' `=($range+3)+1', recast(line) lcolor(red) || ///
              scatteri `=PreSpline2*-2' `=($range-2)+1' 0 `=($range-0)+1' `=PostSpline2*2' `=($range+2)+1', recast(line) lcolor(red) || ///
              scatteri `=PreSpline1*-1' `=($range-1)+1' 0 `=($range-0)+1' `=PostSpline1*1' `=($range+1)+1', recast(line) lcolor(red)    ///
	name(g, replace)

foreach Freq in y m {
	global Per = cond("`Freq'"=="m", 1, cond("`Freq'"=="q", 3, 12))
	local width = 3 + 9 * ("`Freq'"=="y")

	foreach AbramsLEAsOnly in 1 0 {
		use `"$ReplicationPath\Abrams MI`=cond(`AbramsLEAsOnly'," Abrams LEAs","")' `Freq'"', clear
		replace relAddOn = -$range*(12/$Per) if relAddOn < -$range*(12/$Per)
		replace relAddOn =  $range*(12/$Per) if relAddOn >  $range*(12/$Per) & relAddOn < .
		recode  relAddOn (. = 99)
		egen _rel = group(relAddOn), label // "i." operator doesn't like negative values in relAddOn
		levelsof _rel if relAddOn==0
		global rel0 `r(levels)'
		sum _rel, meanonly
		global relmax `r(max)'

		forvalues r=1/3 { // replace dummies for immediate pre- and post- r-year ranges with linear splines and test for difference in slopes
			cap drop PreSpline PostSpline
			gen byte PreSpline  = (relAddOn<0) * (relAddOn>=-`r'*(12/$Per)) * relAddOn
			gen byte PostSpline = (relAddOn>0) * (relAddOn<= `r'*(12/$Per)) * relAddOn
			mi estimate (diff: _b[PreSpline]- _b[PostSpline]), post noupdate esampvaryok: regress lnpcrrobgun *Spline i(1/`=$rel0-`r'*(12/$Per)-1' `=$rel0+`r'*(12/$Per)+1'/$relmax)b$rel0._rel i.t`Freq' i.FIPSState dc* [pw=Pop] if ty>=1970 & ty<=1999, cluster(FIPSState)
			mi testtransform diff
			local p`r' = substr(string(`r(p)', "%4.2f"), 2, .)
			scalar PreSpline`r'  = _b[PreSpline]
			scalar PostSpline`r' = _b[PostSpline]
		}

		mi estimate, post noupdate esampvaryok: regress lnpcrrobgun ib$rel0._rel i.t`Freq' i.FIPSState dc* [pw=Pop] if ty>=1970 & ty<=1999, cluster(FIPSState)

		fvexpand i(`=$rel0-$range*(12/$Per)'/`=$rel0+$range*(12/$Per)')._rel
		coefplot, keep(`=subinstr("`r(varlist)'","b.",".",.)') base cismooth(n(10) lwidth(2 `width') intensity(10 100) color(blue)) vertical ///
			xlabel(`=12/$Per*($range-6)+1' "-6" `=12/$Per*($range-5)+1' "-5" `=12/$Per*($range-4)+1' "-4" `=12/$Per*($range-3)+1' "-3" `=12/$Per*($range-2)+1' "-2" `=12/$Per*($range-1)+1' "-1" `=12/$Per*($range+0)+1' "0" `=12/$Per*($range+1)+1' "1" `=12/$Per*($range+2)+1' "2" `=12/$Per*($range+3)+1' "3" `=12/$Per*($range+4)+1' "4" `=12/$Per*($range+5)+1' "5" `=12/$Per*($range+6)+1' "6", labsize(small)) ///
			`=cond("`Freq'"=="m","",`"title("Multiply imputed data", bmargin(zero)) subtitle("`=cond(`AbramsLEAsOnly'," ","Doubled population coverage")'")"')' ///
			xline(`=$range*(12/$Per)+1') ///
			ylabel(`=cond("`Freq'`AbramsLEAsOnly'"=="m1", `"0 "0%" `=ln(1.5)' "+50%" `=ln(.75)' "-25%", tlen(*.5) labgap(0) angle(horizontal) labsize(small)"', `""""')') ///
			mcolor(none) ///
			graphregion(margin(zero)) legend(off) msize(small) ///
			text(`=ln(.56)' .75 "{it:p} = `p1', `p2', `p3'", place(e) margin(zero)) ///
			yscale(range(`=ln(.55)' `=ln(1.7)')) ///
			generate replace

		`r(graph)' || scatteri `=PreSpline3*-3*(12/$Per)' `=12/$Per*($range-3)+1' 0 `=12/$Per*($range-0)+1' `=PostSpline3*3*(12/$Per)' `=12/$Per*($range+3)+1', recast(line) lcolor(red) || ///
									scatteri `=PreSpline2*-2*(12/$Per)' `=12/$Per*($range-2)+1' 0 `=12/$Per*($range-0)+1' `=PostSpline2*2*(12/$Per)' `=12/$Per*($range+2)+1', recast(line) lcolor(red) || ///
									scatteri `=PreSpline1*-1*(12/$Per)' `=12/$Per*($range-1)+1' 0 `=12/$Per*($range-0)+1' `=PostSpline1*1*(12/$Per)' `=12/$Per*($range+1)+1', recast(line) lcolor(red)  ///
			name(g`Freq'`AbramsLEAsOnly', replace)
	}
}
graph combine g gy1 gy0 gm1 gm0, cols(3) hole(4) title("Years until/since passage of gun add-on sentencing law", margin(small) pos(6) size(small)) graphregion(margin(zero)) name(EventOriginal`Freq', replace)
graph export "$ReplicationPath\Abrams journal.png", replace width(1000)
